@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Delivery_trans.title_page') }} - {{ trans('Delivery_trans.deliver_certificat') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Delivery_trans.title_page') }} / {{ trans('Delivery_trans.deliver_certificat') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Delivery_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
              
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Delivery_trans.deliver_name') }}</th>
                                <th>{{ trans('Delivery_trans.doc_type') }}</th>
                                <th>{{ trans('Certificat_trans.name') }}</th>
                                <th>اسم الموظف</th>
                                <th>{{ trans('Delivery_trans.deliver_date') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($deliveries as $index => $delivery)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $delivery->first_name }} {{ $delivery->second_name }} {{ $delivery->midell_name }} {{ $delivery->last_name }}</td>
                                   <td>
                                    @if ($delivery->type == '1')
                                        <span>{{trans('Delivery_trans.certificat')}} </span>
                                    @elseif ($delivery->type == '2')
                                       <span>{{trans('Delivery_trans.statment')}}</span>
                                    @elseif ($delivery->type == '3')
                                    <span>{{trans('Delivery_trans.record')}}</span>
                                    @elseif ($delivery->type == '4')
                                    <span>{{trans('Delivery_trans.register')}}</span>
                                    @endif
                                   </td>
                                    <td>{{ $delivery->user->first_name }}</td>
                                    <td>{{ $delivery->emp }}</td>
                                    <td>{{ date('d-m-Y', strtotime($delivery->updated_at)) }}</td>
                                   
                                </tr>

                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>


</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('.modal-body #id').val(id);
       
    })

</script>
@toastr_js
@toastr_render
@endsection
