@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Certificat_trans.title_page') }}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
{{ trans('Certificat_trans.title_page') }} 
@stop
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Statment_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Statment_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <a href="{{ route('statments.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                    </a><br><br>

                      <strong>{{ trans('Record_trans.statment') }}</strong>
                         {!! Form::open(['route' => 'statments.store', 'autocomplete' => 'off', 'files' => 'ture' ]) !!}   
                            @csrf
                            <div class="row"> 
                            <div class="col-12 sm-mb-30">
                                <span class="text-danger">{{ trans('main_trans.text5') }} </span>
                            </div>
                            </div><br>
                            
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.First_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="first_name" type="text" value="{{ old('first_name') }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Second_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="second_name" type="text" value="{{ old('second_name') }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Third_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="midell_name" type="text" value="{{ old('midell_name') }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Last_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="last_name" type="text" value="{{ old('last_name') }}">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="notification_number">{{trans('Certificat_trans.notification_number')}} : <span class="text-danger">*</span></label>
                                        <input  class="form-control"  name="notification_number" type="number" value="{{ old('notification_number') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bank">{{trans('Certificat_trans.bank')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="bank" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div>
                            </div>
                            <br>
                            <div class="d-flex justify-content-center">
                                <button type="submit" class="btn btn-primary btn-lg">{{trans('Certificat_trans.submit')}}</button>
                            </div>
                            
                            {!! Form::close() !!}
                     <br><br><br>
                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
@endsection
