@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Refund_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Refund_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Refund_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                {{-- @can('تصدير') 
                <a class="btn btn-warning"
                href="#">
                       تصدير
               </a>

               <a class="btn btn-info"
               href="{{ route('statmentsCount') }}">
                      تقرير
              </a>

             @endcan --}}

            @can('isAdmin') 
           <a href="{{ route('refunds.create') }}">
                <button type="button" class="btn btn-primary l-t-20">
                    {{ trans('Delivery_trans.Add') }}
                </button>
                <br><br> 
            </a>
           

             @endcan
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th> {{ trans('Refund_trans.doc') }} </th>
                                <th> {{ trans('Refund_trans.student_name') }} </th>
                                <th>{{trans('Certificat_trans.notification_number')}}</th>
                                <th>{{trans('Certificat_trans.amount')}}</th>
                                <th>{{ trans('Delivery_trans.request_date') }}</th>
                                <th>{{ trans('Delivery_trans.stauts') }}</th>
                                <th>{{ trans('Depts_trans.Processes') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($refunds as $index => $refund)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        @if ($refund->type == '1')
                                            <span class="label text-info">
                                                {{ trans('Refund_trans.Certificat') }}
                                            </span>
                                        @elseif ($refund->type == '2')
                                        <span class="label text-info">
                                            {{ trans('Refund_trans.Statment') }}
                                        </span>
                                        @elseif ($refund->type == '3')
                                        <span class="label text-info">
                                            {{ trans('Refund_trans.Record') }}
                                        </span>
                                        @else
                                        <span class="label text-info">
                                            {{ trans('Refund_trans.Register') }} 
                                        </span>
                                        @endif
                                    </td>
                                    <td>{{ $refund->user->first_name }}</td>
                                    <td>{{ $refund->notification_number }}</td>
                                    <td>{{ $refund->amount }}</td>
                                    <td>{{ $refund->created_at}}</td>
                                    <td>
                                        @if ($refund->stutus == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($refund->stutus == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                   
                                    <td>
                                       @can('isAdmin') 
                                       <a href="{{ route('deliveries.edit', encrypt($refund->id)) }}">
                                        <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Statment_trans.Edit') }}"><i
                                            class="fa fa-edit"></i></button>
                                       </a>
                                       @endcan
                                      
                                       <a href="{{ route('refunds.show', encrypt($refund->id)) }}">
                                        <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Statment_trans.show') }}"><i
                                            class="fa fa-eye"></i></button>
                                       </a>
                                      
                                        <button type="button" class="btn btn-danger btn-sm" data-toggle="modal"
                                            data-target="#delete{{ $refund->id }}"
                                            title="{{ trans('Statment_trans.Delete') }}"><i
                                                class="fa fa-trash"></i></button>
                                      
                                    </td>
                                </tr>


    <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete{{ $refund->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Refund_trans.delete_Refund') }}
                                                </h5> 
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['refunds.destroy', $refund->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Refund_trans.delete_Refund') }}
                                                <input id="id" type="hidden" name="id" class="form-control"
                                                    value="{{ $refund->id }}">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Statment_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Statment_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>


</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
