@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Refund_trans.title_page') }}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
{{ trans('Refund_trans.title_page') }} 
@stop
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Refund_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Refund_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    {{-- <a href="{{ route('statments.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                    </a><br><br> --}}
                    @if (!empty($certificat) || !empty($record) || !empty($register) || !empty($statment) || !empty($document) ) 
                      <strong>{{ trans('Refund_trans.request_Refund') }}</strong><br>
                      {!! Form::open(['route' => 'refunds.store', 'autocomplete' => 'off', 'files' => 'ture' ]) !!}   
                      @csrf

                      <div class="row">
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Refund_trans.agreement_title') }}</span>
                        </div>
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Refund_trans.info1') }}</span>
                        </div>
                        {{-- Record --}}
                        @if (isset($record))
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Refund_trans.amount') }} : {{$record->amount}} </span>
                            <input type="hidden" name="record_id" class="form-control" value="{{$record->id}}">
                        </div>
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Refund_trans.notification_number') }} : {{$record->notification_number}} </span>
                        </div>
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Certificat_trans.date') }} : {{$record->created_at}} </span>
                        </div>
                        <div class="col-md-12">
                            <img width="300" height="300" src="{{ asset('images/record/' . $record->image) }}">
                        </div>
                        @endif
                        {{-- Certificat --}}
                        @if (isset($certificat))
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Refund_trans.amount') }} : {{$certificat->amount}} </span>
                            <input type="hidden" name="certificat_id" class="form-control" value="{{$certificat->id}}">
                        </div>
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Refund_trans.notification_number') }} : {{$certificat->notification_number}} </span>
                        </div>
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Certificat_trans.date') }} : {{$certificat->created_at}} </span>
                        </div>
                        <div class="col-md-12">
                            <img width="300" height="300" src="{{ asset('images/bank/' . $certificat->bank) }}">
                        </div>
                        @endif
                        {{-- register --}}
                        @if (isset($register))
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Refund_trans.amount') }} : {{$register->amount}} </span>
                            <input type="hidden" name="register_id" class="form-control" value="{{$register->id}}">
                        </div>
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Refund_trans.notification_number') }} : {{$register->notification_number}} </span>
                        </div>
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Certificat_trans.date') }} : {{$register->created_at}} </span>
                        </div>
                        <div class="col-md-12">
                            <img width="300" height="300" src="{{ asset('images/bank/' . $register->bank) }}">
                        </div>
                        @endif
                        
                         {{-- Document --}}
                         @if (isset($document))
                         <div class="col-md-12">
                             <span class="text-danger">{{ trans('Refund_trans.amount') }} : {{$document->amount}} </span>
                             <input type="hidden" name="document_id" class="form-control" value="{{$document->id}}">
                         </div>
                         <div class="col-md-12">
                             <span class="text-danger">{{ trans('Refund_trans.notification_number') }} : {{$document->notification_number}} </span>
                         </div>
                         <div class="col-md-12">
                             <span class="text-danger">{{ trans('Certificat_trans.date') }} : {{$document->created_at}} </span>
                         </div>
                         <div class="col-md-12">
                             <img width="300" height="300" src="{{ asset('images/bank/' . $document->bank) }}">
                         </div>
                         @endif

                        {{-- Statment --}}
                        @if (isset($statment))
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Refund_trans.amount') }} : {{$statment->amount}} </span>
                            <input type="hidden" name="statment_id" class="form-control" value="{{$statment->id}}">
                        </div>
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Refund_trans.notification_number') }} : {{$statment->notification_number}} </span>
                        </div>
                        <div class="col-md-12">
                            <span class="text-danger">{{ trans('Certificat_trans.date') }} : {{$statment->created_at}} </span>
                        </div>
                        <div class="col-md-12">
                        <img width="300" height="300" src="{{ asset('images/statment/' . $statment->image) }}">
                        </div>
                        @endif
                      
                      </div><br>

                      <div class="row">
                        <div class="col-md-3">
                            {{ trans('Delivery_trans.studen_name') }} : {{ Auth::user()->first_name }}
                        </div>
                        <div class="col-md-3">
                            <fieldset>
                                <input type="checkbox" id="agree" name="agree"/>
                                <label>موافق</label>
                            </fieldset>
                        </div>
                      </div><br>
                      
                    <div class="row" id="details">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="bank_account">{{trans('Refund_trans.bank_account')}} : <span class="text-danger">*</span></label>
                                <input  class="form-control"  name="bank_account" type="number" value="{{ old('bank_account') }}">
                            </div>
                            <div class="form-group">
                                <label for="account_owner">{{trans('Refund_trans.account_owner')}} : <span class="text-danger">*</span></label>
                                <input  class="form-control" name="account_owner" type="text" value="{{ old('account_owner') }}">
                            </div>
                        </div>
                      </div>
                      
                    <div class="row " id="doc">
                        <div class="col text-center">
                            <button type="submit" class="btn btn-primary btn-lg">{{trans('Refund_trans.Refund')}}</button>
                        </div>
                    </div>
                    {!! Form::close() !!}
                        <br><br><br>
                     
                     @else
                        
                        <h2>{{trans('Refund_trans.verfy')}}</h2>
                        
                    @endif
                </div>
                
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
   
   <script>
        $(document).ready(function() {
           
            $('#details').hide();
            $('#doc').hide();
           
                 
            $('input[type="checkbox"]').click(function() {
                if ($(this).attr('id') == 'agree') {
                   
                    $('#details').show();
                    $('#doc').show();
                } 
               
            });
        });
    
    </script>

    @endsection
