@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Record_trans.record_information') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Record_trans.record_information') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Record_trans.record_information') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                       <h4> <li>{{ $error }}</li></h4>
                    @endforeach
                </ul>
            </div>
            @endif
            
            <div class="card-body">
                <div class="card-body">
                    <a href="{{ route('records.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br> 
                    </a>
                    <div class="tab nav-border">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                                    role="tab" aria-controls="home-02"
                                    aria-selected="true">{{ trans('Record_trans.record_information') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="profile-02-tab" data-toggle="tab" href="#profile-02"
                                    role="tab" aria-controls="profile-02"
                                    aria-selected="false">{{ trans('Users_trans.Attachments') }}</a>
                            </li>
                            
                            @can('النتيجة')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-03"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Statment_trans.Result_process') }}</a>
                            </li>
                            @endcan
                            @can('المالية')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-04"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Statment_trans.Pay_process') }}</a>
                            </li>
                            @endcan
                             @can('التعليق')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-05"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Certificat_trans.comments') }}</a>
                            </li>
                            @endcan
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="home-02" role="tabpanel"
                                aria-labelledby="home-02-tab">
                                <table class="table table-hover" style="text-align:right">
                                    <tbody>
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.First_name') }}</td>
                                            <td>{{ $record->first_name }} </td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.Second_name') }}</td>
                                            <td>{{ $record->second_name }}</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.Third_name') }}</td>
                                            <td>{{ $record->midell_name }}</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.Last_name') }}</td>
                                            <td>{{ $record->last_name }}</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{trans('Certificat_trans.notification_number')}}</td>
                                            <td>{{ $record->notification_number }}</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Depts_trans.Name_Dept') }}</td>
                                            <td>{{ $record->dept->name }}</td>
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.date') }}</td>
                                            <td>{{ date('d-m-y', strtotime($record->created_at)) }}</td>
                                        </tr>
                                       
                                       <tr>
                                        <th>{{ trans('Statment_trans.Pay_process') }}</th>
                                        <td>
                                            @if ($record->f_status == '0')
                                                <span class="label text-info">
                                                     {{ trans('Statment_trans.processing') }}
                                                </span>
                                            @elseif ($record->f_status == '1')
                                            <span class="label text-success">
                                                {{ trans('Statment_trans.complate') }}
                                            </span>
                                            @else
                                            <span class="label text-danger">
                                                {{ trans('Statment_trans.reject') }}
                                            </span>
                                            @endif
                                        </td>
                                       </tr>
                                    </tr>

                                    @if (isset($record->f_note))
                                    <tr>
                                        <th scope="row">{{ trans('Statment_trans.bank_note') }}</th>
                                        <td> {{ $record->f_note }} </td>
                                    </tr>
                                    @endif
                                    
                                    <tr>
                                        <th>{{ trans('Statment_trans.Result_process') }}</th>
                                        <td>
                                            @if ($record->r_status == '0')
                                                <span class="label text-info">
                                                     {{ trans('Statment_trans.processing') }}
                                                </span>
                                            @elseif ($record->r_status == '1')
                                            <span class="label text-success">
                                                {{ trans('Statment_trans.complate') }}
                                            </span>
                                            @else
                                            <span class="label text-danger">
                                                {{ trans('Statment_trans.reject') }}
                                            </span>
                                            @endif
                                        </td>
                                       </tr>
                                    @if (isset($record->r_note))
                                    <tr>
                                        <th scope="row">{{ trans('Statment_trans.Acadimac_note') }}</th>
                                        <td> {{ $record->r_note }} </td>
                                    </tr>
                                    @endif
                                      @if (isset($record->comments))
                                    <tr>
                                        <th scope="row">{{ trans('Certificat_trans.comments') }}</th>
                                        <td> {{ $record->comments }} </td>
                                    </tr>
                                    @endif
                                    </tbody>
                                </table>
                            </div>

                            <div class="tab-pane fade" id="profile-02" role="tabpanel" aria-labelledby="profile-02-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        
                                    </div>
                                    <br>
                                    <table class="table center-aligned-table mb-0 table table-hover"
                                        style="text-align:center">
                                        <thead>
                                            <tr class="table-secondary">

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <img src="{{ asset('images/record/' . $record->image) }}">
                                                </td>
                                            </tr>
                                           
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            @can('النتيجة')
                            <div class="tab-pane fade" id="profile-03" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        {!! Form::open(['url' => 'processrecordresult', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$record->id}}">
                                       
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="1"
                                                    type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                                </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                </span></label>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Certificat_trans.note') }}</label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                </div>
                            </div>
                            @endcan
                            @can('المالية')
                            <div class="tab-pane fade" id="profile-04" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        
                                        {!! Form::open(['url' => 'processrecordpay', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$record->id}}">
                                       
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="1"
                                                    type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                                </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                </span></label>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Certificat_trans.note') }}</label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                </div>
                            </div>
                            @endcan
                       @can('التعليق')
                             <div class="tab-pane fade" id="profile-05" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                       
                                        {!! Form::open(['url' => 'CommentRrecord', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$record->id}}">
                                       
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Certificat_trans.comments') }}</label>
                                            <textarea name="comments" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                 
                                </div>
                            </div>
                             @endcan
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- row closed -->
    @endsection
    @section('js')
        @toastr_js
        @toastr_render
    @endsection
