@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Graduate_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Graduate_trans.title_page') }}- {{ trans('main_trans.Trashed') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Graduate_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                @can('تصدير') 
                <a class="btn btn-warning"
                href="{{ route('certificatexport') }}">
                       تصدير
               </a>

               <a class="btn btn-info"
               href="{{ route('certificatsCount') }}">
                      تقرير
              </a>
              @endcan
            @can('isAdmin') 
           <a href="{{ route('certificats.create') }}">
                <button type="button" class="btn btn-primary l-t-20">
                    {{ trans('Graduate_trans.submit') }}
                </button>
                <br><br> 
            </a>
            @endcan
           
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Graduate_trans.name') }}</th>
                                <th>{{ trans('Depts_trans.Name_Dept') }}</th>
                                <th>{{ trans('Graduate_trans.date') }}</th>
                                <th>{{ trans('Graduate_trans.certificat_type') }}</th>
                                
                                <th>{{ trans('Graduate_trans.bank_note') }}</th>
                                <th>{{ trans('Graduate_trans.note') }}</th>
                                <th>{{ trans('Depts_trans.Processes') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($certificats as $index => $certificat)
                                <tr>
                                    <td>{{ $certificat->id }}</td>
                                    @if (isset($certificat->first_name[0]))
                                    <td>{{ $certificat->first_name[0] }} {{ $certificat->second_name[0] }} {{ $certificat->midell_name[0] }} {{ $certificat->last_name[0] }}</td>
                                    @else
                                    <td>{{ $certificat->first_name[1] }} {{ $certificat->second_name[1] }} {{ $certificat->midell_name[1] }} {{ $certificat->last_name[1] }}</td>
                                    @endif
                                   
                                    <td>{{ $certificat->dept->name }}</td>

                                    <td>{{ date('d-m-y', strtotime($certificat->created_at)) }}</td>
                                    <td>
                                        @if ($certificat->certificat_type == ["1"])
                                        {{ trans('Graduate_trans.Details') }}
                                        @elseif ($certificat->certificat_type == ["2"])
                                        {{ trans('Graduate_trans.Regular') }}
                                        @else
                                                {{ trans('Graduate_trans.Regular') }} - {{ trans('Graduate_trans.Details') }}
                                        @endif
                                    </td>
                                  
                                    <td>
                                        @if ($certificat->f_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Graduate_trans.Process') }}
                                            </span>
                                        @elseif ($certificat->f_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Graduate_trans.complate') }}
                                        </span>
                                        @else
                                            <span class="label text-danger">
                                                {{ trans('Graduate_trans.reject') }}
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($certificat->r_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Graduate_trans.Process') }}
                                            </span>
                                        @elseif ($certificat->r_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Graduate_trans.complate') }}
                                        </span>
                                        @else
                                            <span class="label text-danger">
                                                {{ trans('Graduate_trans.reject') }}
                                            </span>
                                        @endif
                                    </td>
                                    <td> 
                                      
                                       @can('isUser') 
                                       <a href="{{ route('certificats.edit', encrypt($certificat->id)) }}">
                                        <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Graduate_trans.Edit') }}"><i
                                            class="fa fa-edit"></i></button>
                                       </a>
                                       @endcan
                                       <a href="{{ route('certificats.show', encrypt($certificat->id)) }}">
                                        <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Graduate_trans.show') }}"><i
                                            class="fa fa-eye"></i></button>
                                       </a>
                                       @can('حذف شهادة')
                                        <button class="btn btn-danger btn-sm" data-toggle="modal"
                                            data-target="#delete"
                                            data-id="{{ $certificat->id }}"
                                            data-personal_image="{{ $certificat->personal_image }}"
                                            data-bank="{{ $certificat->bank }}"
                                            data-ssn="{{ $certificat->ssn }}"
                                            data-school_certificat="{{ $certificat->school_certificat }}"

                                          
                                            title="{{ trans('Graduate_trans.Delete') }}"><i
                                                class="fa fa-trash"></i></button>
                                                @endcan
                                    </td>
                                </tr>


    <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Graduate_trans.delete_certificat') }}
                                                </h5> 
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['certificats.destroy', $certificat->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Graduate_trans.Warning_certificat') }}
                                                <input id="id" type="text" name="id" class="form-control">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Graduate_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Graduate_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal_Subject 
   
-->

</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var personal_image = button.data('personal_image')
        var bank = button.data('bank')
        var ssn = button.data('ssn')
        var school_certificat = button.data('school_certificat')
        var modal = $(this)

        modal.find('.modal-body #id').val(id);
        modal.find('.modal-body #personal_image').val(personal_image);
        modal.find('.modal-body #bank').val(bank);
        modal.find('.modal-body #ssn').val(ssn);
        modal.find('.modal-body #school_certificat').val(school_certificat);
    })

</script>

@toastr_js
@toastr_render
@endsection
