@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Document_trans.document_information') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
@section('PageTitle')
    {{ trans('Document_trans.document_information') }}
@stop
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                       <h4> <li>{{ $error }}</li></h4>
                    @endforeach
                </ul>
            </div>
            @endif
            
            <div class="card-body">
                <div class="card-body">
                    <a href="{{ route('documents.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br> 
                    </a>
                    <div class="tab nav-border">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                                    role="tab" aria-controls="home-02"
                                    aria-selected="true">{{ trans('Document_trans.document_information') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="profile-02-tab" data-toggle="tab" href="#profile-02"
                                    role="tab" aria-controls="profile-02"
                                    aria-selected="false">{{ trans('Users_trans.Attachments') }}</a>
                            </li>
                            @can('اجراء التوثيق')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-03"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Document_trans.document_proccess') }}</a>
                            </li>
                            @endcan
                            @can('المالية')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-04"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Statment_trans.Pay_process') }}</a>
                            </li>
                            @endcan
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="home-02" role="tabpanel"
                                aria-labelledby="home-02-tab">
                                <table class="table table-hover" style="text-align:right">
                                    <tbody>
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.certificat_type') }}</td>
                                            <td>
                                                @if ($document->certificat->certificat_type == ["1"])
                                                {{ trans('Certificat_trans.Details') }}
                                                @elseif ($document->certificat->certificat_type == ["2"])
                                                {{ trans('Certificat_trans.Regular') }}
                                                @else
                                                  {{ trans('Certificat_trans.Regular') }} - {{ trans('Certificat_trans.Details') }}
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>{{ trans('Document_trans.document_type') }}</th>
                                            <td>
                                                @if ($document->type == ["1","2","3","4"])
                                                {{ trans('Document_trans.type1') }} - {{ trans('Document_trans.type2') }}
                                                -{{ trans('Document_trans.type3') }} - {{ trans('Document_trans.type4') }}
                                               
                                                @elseif ($document->type == ["1"])
                                                {{ trans('Document_trans.type1') }}
                                                @elseif ($document->type == ["2"])
                                                {{ trans('Document_trans.type2') }}
                                                @elseif ($document->type == ["3"])
                                                {{ trans('Document_trans.type3') }}
                                                @elseif ($document->type == ["4"])
                                                {{ trans('Document_trans.type4') }}
        
                                                @elseif ($document->type == ["1","2"])
                                                {{ trans('Document_trans.type1') }} - {{ trans('Document_trans.type2') }}
                                                @elseif ($document->type == ["3","4"])
                                                {{ trans('Document_trans.type3') }} - {{ trans('Document_trans.type4') }}
        
        
                                                @elseif ($document->type == ["1","3"])
                                                {{ trans('Document_trans.type1') }} - {{ trans('Document_trans.type3') }}
                                                @elseif ($document->type == ["2","4"])
                                                {{ trans('Document_trans.type2') }} - {{ trans('Document_trans.type4') }}
                                              
                                                @else
                                                 نوع التوثيق الذي تم اختيارة غير متاح
                                                @endif
                                            </td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.date') }}</td>
                                            <td>{{ date('d-m-Y', strtotime($document->created_at)) }}</td>
                                        </tr>
                                       
                                      <tr>
                                        {{-- <th>{{ trans('Certificat_trans.note') }}</th> --}}
                                        <th>{{ trans('Certificat_trans.f_status') }}</th>
                                        <td>
                                            @if ($document->f_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Certificat_trans.Process') }}
                                            </span>
                                        @elseif ($document->f_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Certificat_trans.complate') }}
                                        </span>
                                        @else
                                            <span class="label text-danger">
                                                {{ trans('Certificat_trans.reject') }}
                                            </span>
                                        @endif
                                        </td>
                                      </tr>

                                      <tr>
                                       
                                        @if (isset($document->f_note))
                                        <tr>
                                            <th scope="row">{{ trans('Certificat_trans.bank_note') }}</th>
                                            <td> {{ $document->f_note }} </td>
                                        </tr>
                                        @endif
                                      </tr>

                                      <tr>
                                        <th>{{ trans('Document_trans.documents_prosess') }}</th>
                                        <td>
                                            @if ($document->stutus == '0')
                                            <span class="label text-info">
                                                 {{ trans('Certificat_trans.Process') }}
                                            </span>
                                        @elseif ($document->stutus == '1')
                                        <span class="label text-success">
                                            {{ trans('Certificat_trans.complate') }}
                                        </span>
                                        @else
                                            <span class="label text-danger">
                                                {{ trans('Certificat_trans.reject') }}
                                            </span>
                                        @endif
                                        </td>
                                      </tr>
                                      @if (isset($document->note))
                                      <tr>
                                          <th scope="row">{{ trans('Document_trans.emp_note') }}</th>
                                          <td> {{ $document->note }} </td>
                                      </tr>
                                      @endif
                                    </tr>

                                    </tbody>
                                </table>
                            </div>

                            <div class="tab-pane fade" id="profile-02" role="tabpanel" aria-labelledby="profile-02-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        <table class="table center-aligned-table mb-0 table table-hover"
                                        style="text-align:center">
                                        <thead>
                                            <tr class="table-secondary">

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <img src="{{ asset('images/bank/' . $document->bank) }}">
                                                </td>
                                            </tr>
                                            
                                        </tbody>
                                    </table>
                                    </div>
                                  
                                </div>
                            </div>
                           @can('اجراء التوثيق')
                            <div class="tab-pane fade" id="profile-03" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        {!! Form::open(['url' => 'DocumentProcess', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$document->id}}">
                                       
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="1"
                                                    type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                                </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                </span></label>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Certificat_trans.note') }}</label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                  
                                </div>
                            </div>
                            @endcan
                            @can('المالية')
                            <div class="tab-pane fade" id="profile-04" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        {!! Form::open(['url' => 'DocumentPay', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$document->id}}">
                                       
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="1"
                                                    type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                                </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                </span></label>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Certificat_trans.bank_note') }}</label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                 
                                </div>
                            </div>
                            @endcan
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- row closed -->
    @endsection
    @section('js')
        @toastr_js
        @toastr_render
    @endsection
