@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
     {{ trans('Document_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Document_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Document_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
               
           
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Certificat_trans.name') }}</th>
                                <th>{{ trans('Depts_trans.Name_Dept') }}</th>
                                <th>{{ trans('Certificat_trans.date') }}</th>
                                <th>{{ trans('Certificat_trans.certificat_type') }}</th>
                                <!--<th>{{ trans('Document_trans.document_type') }}</th>-->
                                <th>{{ trans('Document_trans.documents_prosess') }}</th>
                                <th>{{ trans('Certificat_trans.bank_note') }}</th>
                                <th>{{ trans('Depts_trans.Processes') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($documents as $index => $document)
                           
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    {{-- <td>{{ $certificat->first_name }} {{ $certificat->second_name }} {{ $certificat->midell_name }} {{ $certificat->last_name }}</td>
                                     --}}
                                    <td>{{ $document->user->first_name }}</td>
                                    <td>{{ $document->user->dept->name }}</td>
                                    <td>{{ date('d-m-y', strtotime($document->created_at)) }}</td>
                                    <td>
                                        @if ($document->certificat->certificat_type == ["1"])
                                        {{ trans('Certificat_trans.Details') }}
                                        @elseif ($document->certificat->certificat_type == ["2"])
                                        {{ trans('Certificat_trans.Regular') }}
                                        @else
                                          {{ trans('Certificat_trans.Regular') }} - {{ trans('Certificat_trans.Details') }}
                                        @endif
                                    </td>
                                    <!--<td>-->
                                    <!--    @if ($document->type == ["1","2","3","4"])-->
                                    <!--    {{ trans('Document_trans.type1') }} - {{ trans('Document_trans.type2') }}-->
                                    <!--    -{{ trans('Document_trans.type3') }} - {{ trans('Document_trans.type4') }}-->
                                       
                                    <!--    @elseif ($document->type == ["1"])-->
                                    <!--    {{ trans('Document_trans.type1') }}-->
                                    <!--    @elseif ($document->type == ["2"])-->
                                    <!--    {{ trans('Document_trans.type2') }}-->
                                    <!--    @elseif ($document->type == ["3"])-->
                                    <!--    {{ trans('Document_trans.type3') }}-->
                                    <!--    @elseif ($document->type == ["4"])-->
                                    <!--    {{ trans('Document_trans.type4') }}-->

                                    <!--    @elseif ($document->type == ["1","2"])-->
                                    <!--    {{ trans('Document_trans.type1') }} - {{ trans('Document_trans.type2') }}-->
                                    <!--    @elseif ($document->type == ["3","4"])-->
                                    <!--    {{ trans('Document_trans.type3') }} - {{ trans('Document_trans.type4') }}-->


                                    <!--    @elseif ($document->type == ["1","3"])-->
                                    <!--    {{ trans('Document_trans.type1') }} - {{ trans('Document_trans.type3') }}-->
                                    <!--    @elseif ($document->type == ["2","4"])-->
                                    <!--    {{ trans('Document_trans.type2') }} - {{ trans('Document_trans.type4') }}-->
                                      
                                    <!--    @else-->
                                    <!--    {{ trans('Document_trans.error_index') }}-->
                                    <!--    @endif-->
                                    <!--</td>-->
                                    <td>
                                        @if ($document->stutus == '0')
                                            <span class="label text-info">
                                                 {{ trans('Certificat_trans.Process') }}
                                            </span>
                                        @elseif ($document->stutus == '1')
                                        <span class="label text-success">
                                            {{ trans('Certificat_trans.complate') }}
                                        </span>
                                        @else
                                            <span class="label text-danger">
                                                {{ trans('Certificat_trans.reject') }}
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($document->f_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Certificat_trans.Process') }}
                                            </span>
                                        @elseif ($document->f_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Certificat_trans.complate') }}
                                        </span>
                                        @else
                                            <span class="label text-danger">
                                                {{ trans('Certificat_trans.reject') }}
                                            </span>
                                        @endif
                                    </td>
                                   
                                    <td>
                                        {{-- @can('isAdmin') 
                                       <a href="{{ route('documents.edit', encrypt($document->id)) }}">
                                        <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Certificat_trans.Edit') }}"><i
                                            class="fa fa-edit"></i></button>
                                       </a>
                                       @endcan  
                                       @can('isUser') 
                                       <a href="{{ route('documents.edit', encrypt($document->id)) }}">
                                        <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Certificat_trans.Edit') }}"><i
                                            class="fa fa-edit"></i></button>
                                       </a>
                                       @endcan --}}
                                       <a href="{{ route('documents.show', encrypt($document->id)) }}">
                                        <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Certificat_trans.show') }}"><i
                                            class="fa fa-eye"></i></button>
                                       </a>
                                       @can('حذف شهادة')
                                        <button class="btn btn-danger btn-sm" data-toggle="modal"
                                            data-target="#delete"
                                            data-id="{{ $document->id }}"
                                               
                                            title="{{ trans('Certificat_trans.Delete') }}"><i
                                                class="fa fa-trash"></i></button>
                                                @endcan
                                    </td>
                                </tr>


    <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Certificat_trans.delete_certificat') }}
                                                </h5> 
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['documents.destroy', $document->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                <input id="id" type="hidden" name="id" class="form-control" value="{{ $document->id }}">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal_Subject 
   
-->

</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var personal_image = button.data('personal_image')
        var bank = button.data('bank')
        var ssn = button.data('ssn')
        var school_certificat = button.data('school_certificat')
        var modal = $(this)

        modal.find('.modal-body #id').val(id);
        modal.find('.modal-body #personal_image').val(personal_image);
        modal.find('.modal-body #bank').val(bank);
        modal.find('.modal-body #ssn').val(ssn);
        modal.find('.modal-body #school_certificat').val(school_certificat);
    })

</script>

@toastr_js
@toastr_render
@endsection
