@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Delivery_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Delivery_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Delivery_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                {{-- @can('تصدير') 
                <a class="btn btn-warning"
                href="#">
                       تصدير
               </a>

               <a class="btn btn-info"
               href="{{ route('statmentsCount') }}">
                      تقرير
              </a>

             @endcan --}}

            @can('isAdmin') 
           <a href="{{ route('deliveries.create') }}">
                <button type="button" class="btn btn-primary l-t-20">
                    {{ trans('Delivery_trans.Add') }}
                </button>
                <br><br> 
            </a>
           

             @endcan
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Delivery_trans.deliver_name') }}</th>
                                 <th>{{ trans('Delivery_trans.doc_type') }}</th>
                                <th>{{ trans('Certificat_trans.name') }}</th>
                                <th>{{ trans('Delivery_trans.request_date') }}</th>
                                {{-- @can('isAdmin')
                                <th>{{ trans('Statment_trans.by') }}</th>
                                @endcan --}}
                                <th>{{ trans('Delivery_trans.stauts') }}</th>
                                <th>{{ trans('Depts_trans.Processes') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($deliveries as $index => $delivery)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $delivery->first_name }} {{ $delivery->second_name }} {{ $delivery->midell_name }} {{ $delivery->last_name }}</td>
                                    <td>
                                    @if ($delivery->type == '1')
                                        <span>{{trans('Delivery_trans.certificat')}} </span>
                                    @elseif ($delivery->type == '2')
                                       <span>{{trans('Delivery_trans.statment')}}</span>
                                    @elseif ($delivery->type == '3')
                                    <span>{{trans('Delivery_trans.record')}}</span>
                                    @elseif ($delivery->type == '4')
                                    <span>{{trans('Delivery_trans.register')}}</span>
                                    @endif
                                   </td>
                                    <td>{{ $delivery->user->first_name }}</td>
                                    <td>{{ date('d-m-Y', strtotime($delivery->created_at)) }}</td>
                                   
                                    {{-- @can('isAdmin')
                                    <td>{{ $delivery->user->name }}</td>
                                    @endcan --}}
                                    <td>
                                        @if ($delivery->stutus == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($delivery->stutus == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                   
                                    <td>
                                       
                                       @can('isAdmin') 
                                       <a href="{{ route('deliveries.edit', encrypt($delivery->id)) }}">
                                        <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Statment_trans.Edit') }}"><i
                                            class="fa fa-edit"></i></button>
                                       </a>
                                       @endcan
                                       @can('isUser') 
                                       <a href="{{ route('deliveries.edit', encrypt($delivery->id)) }}">
                                        <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Statment_trans.Edit') }}"><i
                                            class="fa fa-edit"></i></button>
                                       </a>
                                       @endcan
                                       <a href="{{ route('deliveries.show', encrypt($delivery->id)) }}">
                                        <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                        
                                        title="{{ trans('Statment_trans.show') }}"><i
                                            class="fa fa-eye"></i></button>
                                       </a>
                                       @can('حذف التسليم')
                                        <button type="button" class="btn btn-danger btn-sm" data-toggle="modal"
                                            data-target="#delete{{ $delivery->id }}"
                                            title="{{ trans('Statment_trans.Delete') }}"><i
                                                class="fa fa-trash"></i></button>
                                       @endcan
                                    </td>
                                </tr>


    <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete{{ $delivery->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Delivery_trans.delete_delivery') }}
                                                </h5> 
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['deliveries.destroy', $delivery->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Delivery_trans.Warning_deliveries') }}
                                                <input id="id" type="hidden" name="id" class="form-control"
                                                    value="{{ $delivery->id }}">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Statment_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Statment_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>


</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
