@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Users_trans.personal_information') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
@section('PageTitle')
    {{ trans('Users_trans.personal_information') }}
@stop
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                       <h4> <li>{{ $error }}</li></h4>
                    @endforeach
                </ul>
            </div>
            @endif
            
            <div class="card-body">
                <div class="card-body">
                    <a href="{{ route('certificats.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br> 
                    </a>
                    <div class="tab nav-border">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                                    role="tab" aria-controls="home-02"
                                    aria-selected="true">{{ trans('Users_trans.personal_information') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="profile-02-tab" data-toggle="tab" href="#profile-02"
                                    role="tab" aria-controls="profile-02"
                                    aria-selected="false">{{ trans('Users_trans.Attachments') }}</a>
                            </li>
                            @can('النتيجة')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-03"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Statment_trans.Result_process') }}</a>
                            </li>
                            @endcan
                            @can('المالية')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-04"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Statment_trans.Pay_process') }}</a>
                            </li>
                            @endcan
                             @can('التعليق')
                             <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-05"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Certificat_trans.comments') }}</a>
                            </li>
                             @endcan
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="home-02" role="tabpanel"
                                aria-labelledby="home-02-tab">
                                <table class="table table-hover" style="text-align:right">
                                    <tbody>
                                         @if (isset($certificat->f_note))
                                        <tr>
                                            <th scope="row">{{ trans('Certificat_trans.bank_note') }}</th>
                                            <td> {{ $certificat->f_note }} </td>
                                        </tr>
                                        @endif
                                       @if (isset($certificat->comments))
                                      <tr>
                                          <th scope="row">{{ trans('Certificat_trans.comments') }}</th>
                                          <td>{{ $certificat->comments }} </td>
                                      </tr>
                                      @endif
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.language') }}</td>
                                            <td>
                                                @if ($certificat->lang ==["11"])
                                                {{ trans('Certificat_trans.Arabic') }}
                                                @elseif ($certificat->lang == ["21"])
                                                {{ trans('Certificat_trans.English') }}
                                                @elseif ($certificat->lang == ["21","21"])
                                                {{ trans('Certificat_trans.English') }}
                                                @elseif ($certificat->lang == ["11","11"])
                                                {{ trans('Certificat_trans.Arabic') }}
                                                @else
                                                {{ trans('Certificat_trans.Arabic') }} - {{ trans('Certificat_trans.English') }}
                                                @endif
                                            </td>
                                        </tr>
                                       
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.certificat_type') }}</td>
                                            <td>
                                                @if ($certificat->certificat_type == ["1"])
                                                {{ trans('Certificat_trans.Details') }}
                                                @elseif ($certificat->certificat_type == ["2"])
                                                {{ trans('Certificat_trans.Regular') }}
                                                @else
                                                        {{ trans('Certificat_trans.Regular') }} - {{ trans('Certificat_trans.Details') }}
                                                @endif
                                            </td>
                                        </tr>
                                       
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.First_name') }}</td>
                                            @if (isset($certificat->first_name[0]))
                                            <td colspan="2">{{ $certificat->first_name[0] }} </td>
                                            @endif
                                            @if (isset($certificat->first_name[1]))
                                            <td colspan="2">{{ $certificat->first_name[1] }} </td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.Second_name') }}</td>
                                            @if (isset($certificat->second_name[0]))
                                            <td colspan="2">{{ $certificat->second_name[0] }}</td>
                                            @endif
                                            @if (isset($certificat->second_name[1]))
                                            <td colspan="2">{{ $certificat->second_name[1] }}</td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.Third_name') }}</td>
                                            @if (isset($certificat->midell_name[0]))
                                            <td colspan="2">{{ $certificat->midell_name[0] }}</td>
                                            @endif
                                            @if (isset($certificat->midell_name[1]))
                                            <td colspan="2">{{ $certificat->midell_name[1] }}</td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.Last_name') }}</td>
                                            @if (isset($certificat->last_name[0]))
                                            <td colspan="2">{{ $certificat->last_name[0] }}</td>
                                            @endif
                                            @if (isset($certificat->last_name[1]))
                                            <td colspan="2">{{ $certificat->last_name[1] }}</td>
                                            @endif
                                        </tr>
                                        <tr>
                                            <td scope="row">{{ trans('Depts_trans.Name_Dept') }}</td>
                                            <td>{{ $certificat->dept->name }}</td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{trans('Certificat_trans.certificat_number')}}</td>
                                            <td>{{ $certificat->certificat_number }}</td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{trans('Certificat_trans.amount')}}</td>
                                            <td>{{ $certificat->amount }}</td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{trans('Certificat_trans.notification_number')}}</td>
                                            <td>{{ $certificat->notification_number }}</td>
                                        </tr>

                                        <tr>
                                            <td scope="row">{{ trans('Certificat_trans.date') }}</td>
                                            <td>{{ date('d-m-Y', strtotime($certificat->created_at)) }}</td>
                                        </tr>
                                       
                                      <tr>
                                        {{-- <th>{{ trans('Certificat_trans.note') }}</th> --}}
                                        <th>{{ trans('Certificat_trans.r_status') }}</th>
                                        <td>
                                            @if ($certificat->r_status == '0')
                                                <span class="label text-info">
                                                     {{ trans('Certificat_trans.Process') }}
                                                </span>
                                            @elseif ($certificat->r_status == '1')
                                            <span class="label text-success">
                                                {{ trans('Certificat_trans.complate') }}
                                            </span>
                                            @else
                                                <span class="label text-danger">
                                                    {{ trans('Certificat_trans.reject') }}
                                                </span>
                                            @endif
                                        </td>
                                      </tr>

                                      <tr>
                                       
                                        @if (isset($certificat->r_note))
                                        <tr>
                                            <th scope="row">{{ trans('Certificat_trans.note') }}</th>
                                            <td> {{ $certificat->r_note }} </td>
                                        </tr>
                                        @endif
                                      </tr>

                                      <tr>
                                        {{-- <th>{{ trans('Certificat_trans.bank_note') }}</th> --}}
                                        <th>{{ trans('Certificat_trans.f_status') }}</th>
                                        <td>
                                            @if ($certificat->f_status == '0')
                                                <span class="label text-info">
                                                     {{ trans('Certificat_trans.Process') }}
                                                </span>
                                            @elseif ($certificat->f_status == '1')
                                            <span class="label text-success">
                                                {{ trans('Certificat_trans.complate') }}
                                            </span>
                                            @else
                                                <span class="label text-danger">
                                                    {{ trans('Certificat_trans.reject') }}
                                                </span>
                                            @endif
                                        </td>
                                      </tr>
                                      
                                      @can('isAdmin')
                                      @if (isset($certificat->acdimec_user))
                                      <tr>
                                          <td scope="row">{{ trans('main_trans.acdimec_user') }}</td>
                                          <td>{{ $certificat->acdimec_user }} </td>
                                      </tr>
                                      @endif
                                      @if (isset($certificat->bank_user))
                                      <tr>
                                          <td scope="row">{{ trans('main_trans.bank_user') }}</td>
                                          <td>{{ $certificat->bank_user }} </td>
                                      </tr>
                                      @endif
                                      @endcan
                                     
                                    </tbody>
                                </table>
                            </div>

                            <div class="tab-pane fade" id="profile-02" role="tabpanel" aria-labelledby="profile-02-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        <table class="table center-aligned-table mb-0 table table-hover"
                                        style="text-align:center">
                                        <thead>
                                            <tr class="table-secondary">

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    {{ trans('Certificat_trans.personal_image') }}
                                                    <img height="400" width="400"
                                                        src="{{ asset('images/personalImage/' . $certificat->personal_image) }}">
                                                </td>
                                                <td>
                                                    {{ trans('Certificat_trans.bank') }}
                                                    <img height="400" width="400" src="{{ asset('images/bank/' . $certificat->bank) }}">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    {{ trans('Certificat_trans.ssn') }}
                                                    <img height="400" width="400" src="{{ asset('images/ssn/' . $certificat->ssn) }}">
                                                </td>
                                                <td>
                                                    <img height="400" width="400"
                                                        src="{{ asset('images/schoolCertificat/' . $certificat->school_certificat) }}">
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    </div>
                                  
                                </div>
                            </div>
                            @can('النتيجة')
                            <div class="tab-pane fade" id="profile-03" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        {!! Form::open(['url' => 'CertificatProcessResult', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$certificat->id}}">
                                       
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="1"
                                                    type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                                </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                </span></label>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Certificat_trans.note') }}</label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                  
                                </div>
                            </div>
                            @endcan
                            @can('المالية')
                            <div class="tab-pane fade" id="profile-04" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        {!! Form::open(['url' => 'CertificatProcessPay', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$certificat->id}}">
                                       
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="1"
                                                    type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                                </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                </span></label>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Certificat_trans.bank_note') }}</label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                 
                                </div>
                            </div>
                            @endcan
                            
                             @can('التعليق')
                            {{-- New --}}
                            <div class="tab-pane fade" id="profile-05" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                       
                                        {!! Form::open(['url' => 'CommentCertificat', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$certificat->id}}">
                                       
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Certificat_trans.comments') }}</label>
                                            <textarea name="comments" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                 
                                </div>
                            </div>
                            @endcan
                            
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- row closed -->
    @endsection
    @section('js')
        @toastr_js
        @toastr_render
    @endsection
