<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Specialty;
use Illuminate\Support\Facades\DB;

class SpecialtySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('specialties')->delete();
        $specialties = [
            ['en'=> 'planing', 'ar'=> ' التخطيط'],
            ['en'=> 'Bussiness', 'ar'=> 'ادارة اعمال'],
            ['en'=> 'MBA', 'ar'=> 'ماجستير MBA'],
        ];

        foreach ($specialties as $specialty) {
            Specialty::create(['name' => $specialty]);
        }
    }
}
