<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Grade;
use Illuminate\Support\Facades\DB;
use App\Models\Semester;

class GradeSeeder extends Seeder

{
    /**
     * Run the database seeds. 
     *
     * @return void
     */
    public function run()
    {
        DB::table('grades')->delete();
        $grades = [
            ['en'=> 'First Grade', 'ar'=> 'المستوى الاول'],
            ['en'=> 'Second Grade', 'ar'=> 'المستوى الثاني'],
            ['en'=> 'Thard Grade', 'ar'=> 'المستوى الثالث'],
            ['en'=> 'Forth Grade', 'ar'=> 'المستوى الرابع'],
            ['en'=> 'Five Grade', 'ar'=> 'المستوى الخامس'],
        ];

        foreach ($grades as $grade) {
            Grade::create(['name' => $grade]);
        }
    }




}
