<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('refunds', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('emp_id')->nullable();
            $table->text('note')->nullable();
            $table->decimal('amount',8,2);
            $table->string('type');
            $table->Integer('stutus')->default('0');
            $table->string('notification')->nullable();
            $table->bigInteger('notification_number');
            $table->string('refund')->nullable();
            $table->string('notification_refund')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('refunds');
    }
};
