<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('graduates', function (Blueprint $table) {
            $table->id();
            $table->string('first_name')->nullable();
            $table->string('second_name')->nullable();
            $table->string('midell_name')->nullable();
            $table->string('last_name')->nullable(); 

            $table->unsignedBigInteger('specialty_id');
            $table->string('certificat_type');
            $table->string('number')->default('1');
            $table->string('admission_year');
            $table->string('guraduate_year');

            $table->string('personal_image')->nullable();
            $table->string('bank')->nullable();
            $table->string('ssn')->nullable();
            $table->string('certificat')->nullable();
            $table->string('university_certificat')->nullable();

            $table->string('lang');
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('deleted_id')->nullable();

            $table->string('f_status')->default('0');
            $table->string('r_status')->default('0');
            $table->string('f_note')->nullable();
            $table->string('r_note')->nullable();

            $table->decimal('amount',8,2);
            $table->bigInteger('notification_number');
            $table->Integer('certificat_number');

            $table->Integer('acdimec_user')->nullable();
            $table->Integer('bank_user')->nullable();
            $table->string('print')->default('0');
            $table->string('information_stutus')->default('0');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('graduates');
    }
};
