<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('documents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('certificat_id');
            $table->unsignedBigInteger('user_id');
            $table->string('f_status')->default('0');
            $table->string('r_status')->default('0');
            $table->string('f_note')->nullable();
            $table->string('r_note')->nullable();
            $table->Integer('type');
            $table->Integer('stutus');
            $table->string('note')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('documents');
    }
};
