<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('statments', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('second_name');
            $table->string('midell_name');
            $table->string('last_name'); 
            $table->unsignedBigInteger('dept_id');
            $table->string('f_status')->default('0');
            $table->string('r_status')->default('0');
            $table->string('f_note')->nullable();
            $table->string('r_note')->nullable();
            $table->string('image')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->Integer('acdimec_user')->nullable();
            $table->Integer('bank_user')->nullable();
            $table->bigInteger('notification_number');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('statments');
    }
};
