<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\User;

use Faker\Provider\Base;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    protected $model = User::class;

    public function definition()
    {
        return [
            'name' => $this->faker->name(),
            'email' => $this->faker->unique()->safeEmail(),
            'email_verified_at' => now(), 
            'password' => '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', // password
            'universit_id' => $this->faker->numberBetween($min = 10, $max = 10000).$this->faker->numberBetween($min = 10, $max = 10000),
            'gender_id' => $this->faker->randomElement(['1', '2']),
            'dept_id' => 1,
            'grade_id' => 1,
            'ssn'=>$this->faker->numberBetween($min = 10000000, $max = 100000000),
            'semester_id' => 1,
            'phone' =>$this->faker->PhoneNumber,
            'f_phone' =>$this->faker->PhoneNumber,
            'user_type' => 'stu',
            'remember_token' => Str::random(10),
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     *
     * @return static
     */
    public function unverified()
    {
        return $this->state(function (array $attributes) {
            return [
                'email_verified_at' => null,
            ];
        });
    }
}
