<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class RegisterPuy extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $url = 'https://certificats.eust.edu.sd/ar/registers';

        return (new MailMessage)                 
                    ->subject('التقديم لسجل أكاديمي')
                    ->line('هناك تغير في الحالة المالية للسجل الأكاديمي يرجى مراجعة نظام الشهادات')
                    ->action('عرض السجل الأكاديمي', $url)
                    ->line('شكرا لاستخدامك نظام الشهادات بكلية الامارات للعلوم و التكنولوجيا');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
