<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Grade;
use App\Models\Dept;
use App\Models\Gender;
use App\Models\Statment;
use App\Models\Certificat;
use App\Models\Record;
use App\Models\Document;
use App\Models\Delivery;
use App\Models\Refund;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable implements MustVerifyEmail
{
    use HasApiTokens, HasFactory, Notifiable,HasRoles,HasTranslations,SoftDeletes;
   
    public $translatable = ['first_name','second_name','midell_name','last_name'];
    protected $guarded = [];             
    protected $dates = ['deleted_at'];

   
    protected $hidden = [
        'password',
        'remember_token',
    ];

   
    protected $casts = [
        'email_verified_at' => 'datetime',
        'roles_name' => 'array',
    ];

    public function images()
    {
        return $this->morphMany('App\Models\Image', 'imageable');
    }
    public function dept()  
    {
      return $this->belongsTo(Dept::class);
    } 
    // public function semester() 
    // {
    //   return $this->belongsTo(Semester::class);
    // } 
    public function grade() 
    {
      return $this->belongsTo(Grade::class);
    }  

    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }
   
    public function certificat()
    {
         return $this->hasMany(Certificat::class);
    } 
    public function document()
    {
         return $this->hasMany(Document::class);
    } 
    public function statment()
    {
         return $this->hasMany(Statment::class);
    } 
    public function record()
    {
         return $this->hasMany(Record::class);
    } 
    public function specialty()  
    {
      return $this->belongsTo(Specialty::class);
    }
    public function deliveries()
    {
         return $this->hasMany(Delivery::class);
    } 
    // public function nationality()
    // {
    //     return $this->belongsTo(Nationalitie::class, 'nationalitie_id');
    // }

    // public function blood()
    // {
    //     return $this->belongsTo(Blood::class);
    // }
    public function refund()
    {
         return $this->hasMany(Refund::class);
    } 

    

} // end of class
