<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Graduate;

class Specialty extends Model
{
    use HasFactory,HasTranslations,SoftDeletes;
    protected $dates = ['deleted_at'];
    protected $guarded = [];
    
    public $translatable = ['name'];
    public $timestamps = true;

    public function users()
    {
        return $this->hasMany(User::class); 
    }
    public function graduates()
    {
        return $this->hasMany(Graduate::class); 
    }
    
}
