<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;
use App\Models\Semester;
use App\Models\User;
use App\Models\Register;

class Grade extends Model
{
    use HasFactory;
    use HasTranslations;
    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = [];
    public $translatable = ['name'];

    public function semesters()
    {
         return $this->hasMany(Semester::class);
    } 

    public function users()
    {
        return $this->hasMany(User::class); 
    }
    public function registers()
    {
         return $this->hasMany(Register::class);
    }
   


    
}
