<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;
use App\Models\Subject;
use App\Models\User;
use App\Models\Certificat;
use App\Models\Statment;
use App\Models\Record;

class Dept extends Model
{
    use HasFactory;
    use HasTranslations;
    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = [];
    public $translatable = ['name'];


    public function subjects()
    {
         return $this->hasMany(Subject::class);
    } 
    public function statments()
    {
         return $this->hasMany(Statment::class);
    } 

    public function records()
    {
         return $this->hasMany(Record::class);
    } 

    public function certificats()
    {
         return $this->hasMany(Certificat::class);
    } 
    public function users()
   {
   	return $this->hasMany(User::class); 
   }
   


}
