<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCertificatRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'first_name' => 'required',
            'second_name' => 'required',
            'midell_name' => 'required',
            'last_name' => 'required',
            //'dept_id' => 'required',
            'admission_year' => 'required',
            'guraduate_year' => 'required',
            //'certificat_type' => 'required',
            // 'personal_image' => 'required|image|mimes:jpg,png,jpeg',
            // 'bank' => 'required|image|mimes:jpg,png,jpeg',
            // 'ssn' => 'required|image|mimes:jpg,png,jpeg',
           // 'school_certificat' => 'required|image|mimes:jpg,png,jpeg',
           'notification_number' => 'required|integer',
           'amount' => 'required',
           'certificat_number' => 'required',
        ];
    }
    public function messages()
    {
        return [
           
            'personal_image.image' => 'الصورة الشخصية يجب ان يكون نوع الملف صورة',
            'bank.image' => 'اشعار البنك يجب ان يكون نوع الملف صورة',
            'ssn.image' => 'اثبات الشخصية يجب ان يكون نوع الملف صورة',
            'school_certificat.image' => 'الشهادة السودانية يجب ان تكون نوع الملف صورة',

            'personal_image.required' => 'الصورة الشخصية مطلوبة',
            'bank.required' => 'اشعار البنك مطلوب',
            'ssn.required' => 'اثبات الشخصية مطلوب',
            'school_certificat.required' => 'الشهادة السودانية مطلوبة',

            'admission_year.required' => 'يرجى اختيار عام القبول',
            'guraduate_year.required' => 'يرجى اختيار عام التخرج',
            'second_name.required' => 'يرخى ادخال الاسم الثاني',
            'midell_name.required' => 'يرجى ادخال الاسم الثالث',
            //'dept_id.required' => 'يرجى اختيار القسم',
            'certificat_type.required' => 'يرجى اختيار نوع الشهادة',
            
            'personal_image.mimes' => 'الصورة الشخصية يجب ان يكون نوع الملف صورة',
            'bank.mimes' => 'اشعار البنك يجب ان يكون نوع الملف صورة',
            'ssn.mimes' => 'اثبات الشخصية يجب ان يكون نوع الملف صورة',
            'school_certificat.mimes' => 'الشهادة السودانية يجب ان تكون نوع الملف صورة',
            'notification_number.required' => 'رقم العملية مطلوب',
            'notification_number.integer' => 'رقم العملية يجب ان يكون ارقام',
            'notification_number.unique' => 'رقم العملية مستخدم بالفعل',
            'amount.required' => 'ادخل اجمالي الرسوم',
            'certificat_number.required' => 'يرجى اختيار عدد الشهادات',
        ];
    }
}
