<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreGraduateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'first_name' => 'required',
            'second_name' => 'required',
            'midell_name' => 'required',
            'last_name' => 'required',
            'admission_year' => 'required',
            'guraduate_year' => 'required',
            'certificat_type' => 'required',
            'personal_image' => 'required|image|mimes:jpg,png,jpeg',
            'bank' => 'required|image|mimes:jpg,png,jpeg',
            'ssn' => 'required|image|mimes:jpg,png,jpeg',
            'university_certificat' => 'required|image|mimes:jpg,png,jpeg',
            'lang' => 'required',
            'specialty_id' => 'required',
            'notification_number' => 'required|integer|unique:graduates,notification_number',
            'amount' => 'required',
            'certificat_number' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'personal_image.required' => 'الصورة الشخصية مطلوبة',
            'bank.required' => 'اشعار البنك مطلوب',
            'ssn.required' => 'اثبات الشخصية مطلوب',
            'university_certificat' => 'شهادة البكالريوس مطلوب',
            
            'specialty_id.required' => 'يرجى اختيار التخصص',
            'admission_year.required' => 'يرجى اختيار عام القبول',
            'guraduate_year.required' => 'يرجى اختيار عام التخرج',
            'first_name'=> 'الاسم الاول مطلوب',
            'second_name.required' => 'الاسم الثاني مطلوب',
            'midell_name.required' => 'الاسم الثالث مطلوب',
            'last_name'=> 'الاسم الرابع مطلوب',
           
            'certificat_type.required' => 'يرجى اختيار نوع الشهادة',
            'personal_image.image' => 'الصورة الشخصية يجب ان يكون نوع الملف صورة',
            'bank.image' => 'اشعار البنك يجب ان يكون نوع الملف صورة',
            'ssn.image' => 'اثبات الشخصية يجب ان يكون نوع الملف صورة',
            'university_certificat.image' => 'شهادة البكالريوس يجب ان تكون نوع الملف صورة',

            'personal_image.mimes' => 'الصورة الشخصية يجب ان يكون نوع الملف صورة',
            'bank.mimes' => 'اشعار البنك يجب ان يكون نوع الملف صورة',
            'ssn.mimes' => 'اثبات الشخصية يجب ان يكون نوع الملف صورة',
            'university_certificat.mimes' => 'شهادة البكالريوس يجب ان تكون نوع الملف صورة',
            'lang.required' => 'يرجى تحديد اللغة',
            'notification_number.required' => 'رقم العملية مطلوب',
            'notification_number.integer' => 'رقم العملية يجب ان يكون ارقام',
            'notification_number.unique' => 'رقم العملية مستخدم بالفعل',
            'amount.required' => 'ادخل اجمالي الرسوم',
            'certificat_number.required' => 'يرجى اختيار عدد الشهادات',
        ];
    }

}
