<?php

namespace App\Http\Controllers;

use App\Models\Year;
use App\Http\Requests\StoreYearRequest;
use App\Http\Requests\UpdateYearRequest;

class YearController extends Controller
{
   
    public function index()
    {
        $years = Year::all();
        return view('pages.years.index',compact('years'));
    }

   
    public function create()
    {

    }

   
    public function store(StoreYearRequest $request)
    {
        try 
        {
            $validated = $request->validated();

            $year = new Year();
            $year->name = $request->name;
            $year->save();
    
              toastr()->success(trans('messages.success'));
              return redirect()->route('years.index');

        }

        catch (\Exception $e){
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

   
    public function show(Year $year)
    {
        //
    }

   
    public function edit(Year $year)
    {
        //
    }

    public function update(UpdateYearRequest $request, Year $year)
    {
        //
    }

    
    public function destroy(Year $year)
    {
        try {

            $year->delete();
            toastr()->error(trans('messages.Delete'));
            return redirect()->route('years.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }


}
