<?php

namespace App\Http\Controllers;

use App\Models\Semester;
use App\Http\Requests\StoreSemesterRequest;
use App\Http\Requests\UpdateSemesterRequest;
use App\Models\Grade;

class SemesterController extends Controller
{
    
    public function index()
    {
        $grades = Grade::all();
        $semesters = Semester::all();
        return view('pages.Semester.index',compact('semesters','grades'));
    }

    public function create()
    {
        
    }

    public function store(StoreSemesterRequest $request)
    {
     //dd($request->all());
     $List_semesters = $request->List_semesters;

     try
     {
       
        foreach ($List_semesters as $key => $List_semester) {

            $semester = new Semester();

            $semester->name = ['en' => $List_semester['Name_semester_en'], 'ar' => $List_semester['Name']];

            $semester->grade_id = $List_semester['grade_id'];

            $semester->save();

        }
        toastr()->success(trans('messages.success'));
        return redirect()->route('semesters.index');

     }
     catch (\Exception $e) {
        return redirect()->back()->withErrors(['error' => $e->getMessage()]);
    }

     /*
     $semester = new Semester();
     $semester->name = ['en' => $request->Name_en, 'ar' => $request->Name];
     $semester->grade_id = $request->grade_id;
     $semester->save();

       toastr()->success(trans('messages.success'));
       return redirect()->route('semesters.index');
    */
    }

    public function show(Semester $semester)
    {
        
    }

    public function edit(Semester $semester)
    {
        //
    }

    public function update(UpdateSemesterRequest $request, Semester $semester)
    {
        //
    }

    public function destroy(Semester $semester)
    {
        //
    }
}
