<?php

namespace App\Http\Controllers;

use App\Models\Result;
use App\Http\Requests\StoreResultRequest;
use App\Http\Requests\UpdateResultRequest;
use Illuminate\Http\Request;
use App\Models\Dept;
use App\Models\Subject;
use App\Models\Semester;
use App\Models\Year;
use App\Models\User;

class ResultController extends Controller
{
   
    public function index()
    {
        //
    }

  
    public function create(Request $request)
    {
        $dept = $request->dept;
        $semester = $request->semester_id;
        $grade = $request->grade_id;
        $subject = $request->subject;
        $year = $request->year;

        $depts = Dept::all();
        $subjects = Subject::all();
        $semesters = Semester::all();
        $years = Year::all();

        $users = User::where('dept_id', $dept)
        ->where('user_type','stu')
        //->where('semester_id',$semester)
        ->where('grade_id',$grade)
        ->get();

        return view('pages.results.main.create',compact('users','years','depts','subjects','semesters'));
    }

    public function store(StoreResultRequest $request)
    {
        
    }

    public function Get_semesters($id)
    {
        $list_semester = Semester::all()->pluck('name','id');
    
        //return $list_semester;
       
    }

    public function Get_subject($id)
    {
        $list_subject = Subject::where('semester_id', $id)->pluck('name','id');
        return $list_subject;
        //return json_encode ($list_subject);
    }

   
    public function show(Result $result)
    {
        //
    }

    public function edit(Result $result)
    {
        //
    }

    
    public function update(UpdateResultRequest $request, Result $result)
    {
        //
    }

    public function destroy(Result $result)
    {
        //
    }
}
