<?php

namespace App\Http\Controllers;


use App\Http\Requests\StoreGraduateRequest;
use App\Http\Requests\UpdateGraduateRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Exports\CertificatsExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Models\Graduate;
use App\Models\Dept;
use App\Models\Year;
use App\Models\Specialty;
use Image;

class GraduateController extends Controller
{
    function __construct()
    { 

    $this->middleware('permission:عرض شهادة', ['only' => ['index']]);
    $this->middleware('permission:اضافة شهادة', ['only' => ['create','store']]);
    $this->middleware('permission:تعديل شهادة', ['only' => ['edit','update']]);
    $this->middleware('permission:حذف شهادة', ['only' => ['destroy']]);

    }

    public function index()
    {
         if(Auth::user()->user_type == 'stu')
        {
            $graduates = Graduate::where('user_id', Auth::user()->id)->get();

        }
        else
        {
            $graduates = Graduate::where('r_status',0)
            ->Orwhere('f_status',0)
            ->get();
        }
        return view('pages.Graduates.index',compact('graduates'));
    }

   
    public function create()
    {
        $specialties =  Specialty::all();
        $years =  Year::all();
       
        return view('pages.Graduates.create',compact('specialties','years'));
    }

   
    public function store(StoreGraduateRequest $request)
    {
        try {
           // DB::beginTransaction();
            $validated = $request->validated();

            $graduate = new Graduate; 

            $graduate->midell_name =  $request->midell_name;
            $graduate->second_name = $request->second_name;
            $graduate->first_name = $request->first_name;
            $graduate->last_name = $request->last_name;
            $graduate->certificat_type = $request->certificat_type;
            $graduate->lang =$request->lang;
            $graduate->specialty_id =$request->specialty_id;
            $graduate->admission_year = $request->admission_year;
            $graduate->guraduate_year = $request->guraduate_year;
            $graduate->user_id = Auth::user()->id;
            $graduate->amount =$request->amount;
            $graduate->notification_number =$request->notification_number;
            $graduate->certificat_number =$request->certificat_number;
                
           
            if ($request->hasFile('personal_image')) {
                $image = $request->file('personal_image');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = public_path('images/personalImage/' . $filename);
                Image::make($image)->resize(500, 500)->save($location);
                $graduate->personal_image = $filename;
            }  
            if ($request->hasFile('bank')) {
                $image = $request->file('bank');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = public_path('images/bank/' . $filename);
                Image::make($image)->resize(500, 600)->save($location);
                $graduate->bank = $filename;
            } 
            if ($request->hasFile('ssn')) {
                $image = $request->file('ssn');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = public_path('images/ssn/' . $filename);
                Image::make($image)->resize(500, 600)->save($location);
                $graduate->ssn = $filename;
            }  
            if ($request->hasFile('university_certificat')) {
                $image = $request->file('university_certificat');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = public_path('images/schoolCertificat/' . $filename);
                Image::make($image)->resize(500, 600)->save($location);
                $graduate->university_certificat = $filename;
            }  
        
            
            $graduate->save();
        
            // $user = User::where('id', Auth::user()->id)->first();
            // $user->update([
            // 'certificats' => '1',
            //     ]);
            //     DB::commit();
                toastr()->success(trans('messages.success'));
                return redirect()->route('graduates.index');

               
            }
    
            catch (\Exception $e){
            // DB::rollback();
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
             }
    }

   
    public function show($id)
    {
       
        $graduate = Graduate::find(decrypt($id));
        return view('pages.Graduates.show',compact('graduate'));
    }

   
    public function edit(Graduate $graduate)
    {
        //
    }

    public function update(UpdateGraduateRequest $request, Graduate $graduate)
    {
        //
    }

  
    public function destroy(Request $request)
    {
        try {
            $graduate = Graduate::where('id',$request->id)->first();
            $graduate->update([
            'deleted_id' => (Auth::user()->id),
                ]);
             $graduate->delete();
             toastr()->error(trans('messages.Delete'));
            return redirect()->route('graduates.index');
        }

        catch (\Exception $e){
        return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

    public function GraduateProcessResult(Request $request)
    {
       
            $validatedData = $request->validate([
                'rdio' => 'required',
            ],[

                'rdio.required' =>'يرجي تحديد الحالة الأكاديمية للشهادة',
            
            ]);
           try {
                $graduate = Graduate::where('id',$request->id)->first();
                $graduate->update([
                'r_status' => $request->rdio,
                'r_note' => $request->note,
                'acdimec_user'=> Auth::user()->id,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }
                toastr()->success(trans('messages.success'));
                return redirect('/graduates');

    }

    public function GraduateProcessPay(Request $request)
    {
       
            $validatedData = $request->validate([
                'rdio' => 'required',
            ],[

                'rdio.required' =>'يرجي تحديد الحالة المالية للشهادة',
            
            ]);
           try {
                $graduate = Graduate::where('id',$request->id)->first();
                $graduate->update([
                'f_status' => $request->rdio,
                'f_note' => $request->note,
                'bank_user'=> Auth::user()->id,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }
                toastr()->success(trans('messages.success'));
                return redirect('/graduates');

    }
    public function ArchiveGraduate() 
    {
        $graduates = Graduate::onlyTrashed()->get();
        return view('pages.Certificat.ArchiveGraduate',compact('graduates'));
       
    }



}
