@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Refund_trans.Refund_information') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Refund_trans.Refund_information') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Refund_trans.Refund_information') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                       <h4> <li>{{ $error }}</li></h4>
                    @endforeach
                </ul>
            </div>
            @endif
            
            <div class="card-body">
                <div class="card-body">
                    <a href="{{ route('refunds.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br> 
                    </a>
                    <div class="tab nav-border">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                                    role="tab" aria-controls="home-02"
                                    aria-selected="true">{{ trans('Refund_trans.Refund_information') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="profile-02-tab" data-toggle="tab" href="#profile-02"
                                    role="tab" aria-controls="profile-02"
                                    aria-selected="false">{{ trans('Users_trans.Attachments') }}</a>
                            </li>
                           
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-03"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Refund_trans.Refund_prosess') }}</a>
                            </li>
                            
                            {{-- @can('المالية')
                            <li class="nav-item">
                                <a class="nav-link" id="profile-03-tab" data-toggle="tab" href="#profile-04"
                                    role="tab" aria-controls="profile-03"
                                    aria-selected="false">{{ trans('Statment_trans.Pay_process') }}</a>
                            </li>
                            @endcan --}}
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="home-02" role="tabpanel"
                                aria-labelledby="home-02-tab">
                                <table class="table table-hover" style="text-align:right">
                                    <tbody>
                                        <tr>
                                            <td scope="row">{{trans('Certificat_trans.notification_number')}}</td>
                                            <td>{{ $refund->notification_number }} </td>
                                        </tr>
                                        
                                        <tr>
                                            <td scope="row">{{trans('Certificat_trans.amount')}}</td>
                                            <td>{{ $refund->amount }}</td>
                                        </tr>
                                       
                                        <tr>
                                            <td scope="row">{{ trans('Delivery_trans.request_date') }}</td>
                                            <td>{{ $refund->created_at }}</td>
                                        </tr>
                                        
                                       <tr>
                                        <th>{{ trans('Delivery_trans.stauts') }}</th>
                                        <td>
                                            @if ($refund->stutus == '0')
                                                <span class="label text-info">
                                                     {{ trans('Statment_trans.processing') }}
                                                </span>
                                            @elseif ($refund->stutus == '1')
                                            <span class="label text-success">
                                                {{ trans('Statment_trans.complate') }}
                                            </span>
                                            @else
                                            <span class="label text-danger">
                                                {{ trans('Statment_trans.reject') }}
                                            </span>
                                            @endif
                                        </td>
                                       </tr>
                                       <tr>
                                        @if (isset($refund->note))
                                        <td scope="row">{{ trans('Delivery_trans.note') }}</td>
                                        <td>{{ $refund->note }}</td>
                                        @endif
                                        </tr>
                                    </tr>
                                       
                                    </tbody>
                                </table>
                            </div>

                            <div class="tab-pane fade" id="profile-02" role="tabpanel" aria-labelledby="profile-02-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        
                                    </div>
                                    <br>
                                    <table class="table center-aligned-table mb-0 table table-hover"
                                        style="text-align:center">
                                        <thead>
                                            <tr class="table-secondary">

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <img src="{{ asset('images/bank/' . $refund->notification) }}">
                                                </td>
                                            </tr>
                                           
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            @can('اجراء استرداد')
                            <div class="tab-pane fade" id="profile-03" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        {!! Form::open(['url' => 'deliveryprocess', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$refund->id}}">
                                       
                                       <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                        <label class="rdiobox"><input name="rdio" value="1"
                                                type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                            </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                </span></label>
                                        </div>

                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label for="amount">{{trans('Refund_trans.amount2')}} : <span class="text-danger">*</span></label>
                                            <input  class="form-control"  name="notification_number" type="number" value="{{ old('notification_number') }}">
                                        </div>

                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label for="bank">{{trans('Certificat_trans.bank')}} : <span class="text-danger">*</span></label>
                                            <input type="file" name="notification_refund" class="dropify"
                                              accept="image/*" data-height="80" />
                                        </div>
                                        {{-- <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label for="notification_number">{{trans('Certificat_trans.notification_number')}} : <span class="text-danger">*</span></label>
                                            <input  class="form-control"  name="notification_number" type="number" value="{{ old('notification_number') }}">
                                        </div> --}}
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1"><strong>{{ trans('Delivery_trans.deliveries_emp') }} : </strong></label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                </div>
                            </div>
                            @endcan
                            {{-- @can('المالية')
                            <div class="tab-pane fade" id="profile-04" role="tabpanel" aria-labelledby="profile-03-tab">
                                <div class="card card-statistics">
                                    <div class="card-body">
                                        
                                        {!! Form::open(['url' => 'processpay', 'autocomplete' => 'off' ]) !!}   
                                        @csrf
                                       <input type="hidden" name="id" value="{{$statment->id}}">
                                       
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="1"
                                                    type="radio"><span> {{ trans('Certificat_trans.accept') }}
                                                </span></label>
                                        </div>
                                        <div class="col-lg-3 mg-t-20 mg-lg-t-0">
                                            <label class="rdiobox"><input name="rdio" value="2"
                                                    type="radio"><span> {{ trans('Certificat_trans.reject') }}
                                                </span></label>
                                        </div>
                                        
                                        <div class="col-lg-6">
                                            <label for="exampleFormControlTextarea1">{{ trans('Certificat_trans.note') }}</label>
                                            <textarea name="note" class="form-control" wire:model="Address_Father" id="exampleFormControlTextarea1" rows="4"></textarea>
                                        </div>

                                       <br>

                                        <div class="parsley-input col-md-3 mg-t-20 mg-md-t-0">
                                            <button
                                                class="btn btn-primary btn-block">{{ trans('Main_trans.save') }}</button>
                                        </div>
                                        </form>

                                        {!! Form::close() !!}
                                    </div>

                                </div>
                            </div>
                            @endcan --}}
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <!-- row closed -->
    @endsection
    @section('js')
        @toastr_js
        @toastr_render
    @endsection
